/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.HealpixImpl;
import cds.moc.Moc;
import cds.moc.Moc2D;
import cds.moc.Range;
import cds.moc.SMoc;
import cds.moc.TMoc;
import java.io.InputStream;
import java.io.OutputStream;

public class STMoc
extends Moc2D {
    private boolean PROTOSTMOC = false;

    public STMoc() {
        super(new TMoc(), new SMoc());
    }

    public STMoc(int timeOrder, int spaceOrder) throws Exception {
        this();
        this.setMocOrder(timeOrder, spaceOrder);
    }

    public STMoc(String s) throws Exception {
        this();
        this.add(s);
    }

    public STMoc(InputStream in) throws Exception {
        this();
        this.read(in);
    }

    public STMoc(TMoc tmoc, SMoc smoc) throws Exception {
        this();
        this.init(tmoc, smoc);
    }

    private STMoc(SMoc moc, int timeOrder) throws Exception {
        this(timeOrder, moc.getMocOrder());
        this.initDim2(moc);
    }

    private STMoc(TMoc moc, int spaceOrder) throws Exception {
        this(moc.getMocOrder(), spaceOrder);
        this.initDim1(moc);
    }

    protected static STMoc asSTMoc(Moc moc) throws Exception {
        moc.flush();
        if (moc instanceof STMoc) {
            return (STMoc)moc;
        }
        if (moc instanceof TMoc) {
            return new STMoc((TMoc)moc, moc.getSpaceOrder());
        }
        if (moc instanceof SMoc) {
            return new STMoc((SMoc)moc, moc.getTimeOrder());
        }
        throw new Exception("No time or space dimension");
    }

    @Override
    public STMoc clone() throws CloneNotSupportedException {
        STMoc moc = this.dup();
        this.clone1(moc);
        return moc;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof STMoc)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must be STMoc");
        }
        super.clone1(moc);
    }

    @Override
    public STMoc dup() {
        STMoc moc = new STMoc();
        moc.protoDim1.sys = this.protoDim1.sys;
        moc.protoDim2.sys = this.protoDim2.sys;
        return moc;
    }

    public void add(HealpixImpl healpix, double alpha, double delta, double jdmin, double jdmax) throws Exception {
        long smin = healpix.ang2pix(29, alpha, delta);
        long tmin = Double.isNaN(jdmin) ? 0L : (long)(jdmin * 8.64E10);
        long tmax = Double.isNaN(jdmax) ? TMoc.NBVAL_T : (long)(jdmax * 8.64E10);
        this.add(tmin, tmax, smin, smin);
    }

    public void add(int order, long npix, double jdmin, double jdmax) throws Exception {
        long smin = this.getStart2(order, npix);
        long smax = this.getEnd2(order, npix) - 1L;
        long tmin = Double.isNaN(jdmin) ? 0L : (long)(jdmin * 8.64E10);
        long tmax = Double.isNaN(jdmax) ? TMoc.NBVAL_T : (long)(jdmax * 8.64E10);
        this.add(tmin, tmax, smin, smax);
    }

    public void add(long tmin, long tmax, long smin, long smax) throws Exception {
        this.add(61, tmin, tmax, 29, smin, smax);
    }

    public void add(double jdmin, double jdmax, SMoc smoc) throws Exception {
        long tmin = Double.isNaN(jdmin) ? 0L : (long)(jdmin * 8.64E10);
        long tmax = Double.isNaN(jdmax) ? TMoc.NBVAL_T : (long)(jdmax * 8.64E10);
        this.add(tmin, tmax, new Range(smoc.seeRangeList()));
    }

    @Override
    public void setTimeOrder(int timeOrder) throws Exception {
        this.setMocOrder1(timeOrder);
    }

    @Override
    public void setSpaceOrder(int spaceOrder) throws Exception {
        this.setMocOrder2(spaceOrder);
    }

    @Override
    public int getTimeOrder() {
        return this.getMocOrder1();
    }

    @Override
    public int getSpaceOrder() {
        return this.getMocOrder2();
    }

    @Override
    public void setSpaceSys(String coosys) {
        this.protoDim2.setSys(coosys);
    }

    @Override
    public String getSpaceSys() {
        return this.protoDim2.getSys();
    }

    @Override
    public void setTimeSys(String timesys) {
        this.protoDim1.setSys(timesys);
    }

    @Override
    public String getTimeSys() {
        return this.protoDim1.getSys();
    }

    public double getTimeMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return (double)this.range.begins(0) / 8.64E10;
    }

    public double getTimeMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return (double)this.range.ends(this.range.nranges() - 1) / 8.64E10;
    }

    public int getTimeRanges() {
        return this.getNbRanges();
    }

    @Override
    public TMoc getTimeMoc() throws Exception {
        TMoc moc = new TMoc(this.getTimeOrder());
        moc.setRangeList(new Range(this.range));
        return moc;
    }

    public TMoc getTimeMoc(SMoc spaceMoc) throws Exception {
        if (spaceMoc == null || spaceMoc.isEmpty()) {
            return this.getTimeMoc();
        }
        TMoc moc = new TMoc(this.getTimeOrder());
        Range r1 = new Range();
        for (int i = 0; i < this.range.sz; i += 2) {
            Range m = this.range.rr[i >>> 1];
            if (!spaceMoc.range.overlaps(m)) continue;
            r1.append(this.range.r[i], this.range.r[i + 1]);
        }
        moc.range = r1;
        return moc;
    }

    @Override
    public SMoc getSpaceMoc() throws Exception {
        return this.getSpaceMoc(-1L, Long.MAX_VALUE);
    }

    public SMoc getSpaceMoc(long tmin, long tmax) throws Exception {
        int pos;
        boolean isSFull;
        if (tmin > tmax) {
            throw new Exception("bad time range");
        }
        if (this.range.sz == 0) {
            SMoc moc = new SMoc(this.getSpaceOrder());
            moc.setSpaceSys(this.getSpaceSys());
            return moc;
        }
        boolean bl = isSFull = tmin <= this.range.r[0] && tmax >= this.range.r[this.range.sz - 1];
        if (isSFull) {
            if (this.range.sz == 2) {
                SMoc moc = new SMoc(this.getSpaceOrder());
                moc.setSpaceSys(this.getSpaceSys());
                moc.setRangeList(this.range.rr[0]);
                return moc;
            }
            if (this.cacheDim2Full != null) {
                return (SMoc)this.cacheDim2Full;
            }
        }
        if (((pos = this.range.indexOf(tmin)) & 1) == 1) {
            pos = pos < 0 ? ++pos : --pos;
        }
        SMoc moc = new SMoc(this.getSpaceOrder());
        moc.setSpaceSys(this.getSpaceSys());
        moc.bufferOn(2000000);
        for (int i = pos; i < this.range.sz && this.range.r[i] <= tmax; i += 2) {
            Range m = this.range.rr[i >>> 1];
            for (int j = 0; j < m.sz; j += 2) {
                moc.add(29, m.r[j], m.r[j + 1] - 1L);
            }
        }
        moc.bufferOff();
        if (isSFull) {
            this.cacheDim2Full = moc;
        }
        return moc;
    }

    public boolean contains(long npix, double jd) {
        long npixTime = (long)(jd * 8.64E10);
        int i = this.range.indexOf(npixTime);
        if ((i & 1) != 0) {
            return false;
        }
        return this.range.rr[i / 2].contains(npix);
    }

    @Override
    public boolean isIncluding(Moc moc) throws Exception {
        if (moc instanceof SMoc) {
            return this.getSpaceMoc().isIncluding(moc);
        }
        if (moc instanceof TMoc) {
            return this.getTimeMoc().isIncluding(moc);
        }
        if (!(moc instanceof STMoc)) {
            throw new Exception("no time or space dimension");
        }
        this.flush();
        return this.range.contains(moc.seeRangeList());
    }

    @Override
    public boolean isIntersecting(Moc moc) throws Exception {
        if (moc instanceof SMoc) {
            return this.getSpaceMoc().isIntersecting(moc);
        }
        if (moc instanceof TMoc) {
            return this.getTimeMoc().isIntersecting(moc);
        }
        if (!(moc instanceof STMoc)) {
            throw new Exception("no time or space dimension");
        }
        this.flush();
        return this.range.overlaps(moc.seeRangeList());
    }

    @Override
    public STMoc union(Moc moc) throws Exception {
        return (STMoc)super.union(STMoc.asSTMoc(moc));
    }

    @Override
    public STMoc subtraction(Moc moc) throws Exception {
        return (STMoc)super.subtraction(STMoc.asSTMoc(moc));
    }

    @Override
    public STMoc intersection(Moc moc) throws Exception {
        return (STMoc)super.intersection(STMoc.asSTMoc(moc));
    }

    @Override
    public STMoc complement() throws Exception {
        STMoc moc = new STMoc(this.getTimeOrder(), this.getSpaceOrder());
        moc.add("t0/0 s0/0-11");
        return moc.subtraction(this);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(STMoc.getFitsLine("MOCDIM", "TIME.SPACE", "STMOC: Time dimension first, "));
        n += 80;
        out.write(STMoc.getFitsLine("ORDERING", "RANGE", "Range coding"));
        n += 80;
        out.write(STMoc.getFitsLine("MOCORD_T", "" + this.getTimeOrder(), "Time MOC resolution"));
        n += 80;
        out.write(STMoc.getFitsLine("MOCORD_S", "" + this.getSpaceOrder(), "Space MOC resolution"));
        n += 80;
        out.write(STMoc.getFitsLine("COORDSYS", this.getSpaceSys(), "Space reference frame"));
        n += 80;
        out.write(STMoc.getFitsLine("TIMESYS", this.getTimeSys(), "Time ref system"));
        return n += 80;
    }

    @Override
    protected long codeDim1(long a) {
        return this.codeTime(a);
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, Moc.HeaderFits header) throws Exception {
        int timeOrder = -1;
        int spaceOrder = -1;
        String type = header.getStringFromHeader("MOCDIM");
        if (type != null) {
            timeOrder = header.getIntFromHeader("MOCORD_T");
            spaceOrder = header.getIntFromHeader("MOCORD_S");
        } else {
            type = header.getStringFromHeader("MOC");
            if (type == null || type.equals("SPACETIME")) {
                timeOrder = header.getIntFromHeader("TORDER") * 2 + 3;
                spaceOrder = header.getIntFromHeader("MOCORDER");
            } else {
                timeOrder = header.getIntFromHeader("MOCORDER") * 2 + 3;
                spaceOrder = header.getIntFromHeader("MOCORD_1");
            }
            this.PROTOSTMOC = true;
        }
        this.setTimeOrder(timeOrder);
        this.setSpaceOrder(spaceOrder);
        byte[] buf = new byte[naxis1 * naxis2];
        STMoc.readFully(in, buf);
        this.readSpecificDataRange(naxis1 * naxis2 / nbyte, buf, 0);
    }

    @Override
    protected boolean isCodedTime(long a) {
        if (this.PROTOSTMOC) {
            return a < 0L;
        }
        return super.isCodedTime(a);
    }

    @Override
    protected long decodeTime(long a) {
        if (this.PROTOSTMOC) {
            return -a;
        }
        return super.decodeTime(a);
    }

    @Override
    protected boolean isCodedDim1(long a) {
        return this.isCodedTime(a);
    }

    @Override
    protected long decodeDim1(long a) {
        return this.decodeTime(a);
    }
}

